﻿using System;
using System.Collections.Generic;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Create
{
    public class GetProvidersStep : FilterBase<VideoVisitCreateStateObject>
    {
        public override void Execute(VideoVisitCreateStateObject state)
        {
            if (state.ServiceAppointment.Resources == null || state.ServiceAppointment.Resources.ToList().Count == 0) throw new Exception("Resources must be specified for all appointments");

            var bookedSysUsers = state.ServiceAppointment.Resources.Where(r => r.PartyId.LogicalName == "systemuser").ToList();

            var isStoreForward = state.ServiceAppointment.cvt_TelehealthModality ?? false;
            if (bookedSysUsers.Count == 0 && !isStoreForward) throw new Exception("Unable to retrieve Provider Data");

            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                var tsa = srv.mcs_servicesSet.FirstOrDefault(t => t.Id == state.ServiceAppointment.mcs_relatedtsa.Id);
                if (tsa == null) throw new Exception("No TSA is associated with the service activity");
                var parties = bookedSysUsers.Select(ap => ap.PartyId.Id);

                //Query for PRGs Listing the Provider as a user directly
                var prgs = srv.cvt_providerresourcegroupSet.Where(prg => prg.cvt_RelatedTSAid.Id == tsa.Id && prg.cvt_RelatedUserId != null).Select(prg => prg.cvt_RelatedUserId.Id).ToList();

                //Query for PRGs Listing the Provider as a user through a group
                var groupPrgs = srv.cvt_providerresourcegroupSet.Where(prg => prg.cvt_RelatedTSAid.Id == tsa.Id && prg.cvt_RelatedResourceGroupid != null).Select(prg => prg.cvt_RelatedResourceGroupid.Id).ToList();
                var groupResourceUserIds = new List<Guid>();

                foreach (var prg in groupPrgs)
                {
                    groupResourceUserIds = srv.mcs_groupresourceSet.Where(gr => gr.mcs_relatedResourceGroupId.Id == prg && gr.mcs_RelatedUserId != null).Select(gr => gr.mcs_RelatedUserId.Id).ToList();
                }

                //Match Group PRGs with booked resources
                var matches = new List<Guid>();

                foreach (var party in parties)
                {
                    if (groupResourceUserIds.Contains(party))
                        matches.Add(party);
                    if (prgs.Contains(party))
                        matches.Add(party);
                }
                foreach (var match in matches)
                {
                    var user = srv.SystemUserSet.FirstOrDefault(u => u.Id == match);
                    state.SystemUsers.Add(user);
                }
            }

        }
    }
}
